******************************************************************************************************************
* Disability employment results WITHOUT bootstrap
* This can't do PPWD (without getting SUEST to work), nor the full randomness for predicted dis - but otherwise correct
* Started 28/6/2023
******************************************************************************************************************

// The analysis
local measures "${disvar} ${IRTvar} ${predictedvar}_fxd ${predictedvar} "
foreach measure in `measures' {
	* Disability model
	eststo d_`measure'		: logit `measure'  i.${countryvar} 						$controls $controls2 ${if} [pw=${pweight}]
		eststo dM_`measure' :	margins i.${countryvar}, 				 at(${controlsmeans}) post
	* Employment model
	eststo e_`measure'		: logit ${empvar}  ib(0).`measure'##i.${countryvar} 	$controls $controls2 ${if} [pw=${pweight}]
		eststo eMi_`measure':	margins i.`measure', over(${countryvar}) at(${controlsmeans}) post	
		* NOTE: the previous line uses over($countryvar). But this produces the same results as '@$countryvar if the covariates are set to fixed values in 'at'.
		estimates restore e_`measure'
		eststo eMr_`measure':	margins r.`measure'@${countryvar}, 		 at(${controlsmeans}) post
/**/							}


// The tables
local countrylabel: value label ${countryvar}
numlabel `countrylabel', mask(#_) remove
levelsof ${countryvar}
foreach country in `r(levels)'	{
	* Renaming the variables from four equations so that they display in the same rows
	local countrylab: label (${countryvar}) `country'
	local countrylab = subinstr("`countrylab'", " ", "_", .)		// estttab, rename() doesn't work with spaces, so need to remove this, and use the 'varlabels' option to insert the space back in
	local rename_eMr `"`rename_eMr' r1vs0.${disvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${IRTvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${predictedvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${predictedvar}_fxd@`country'.${countryvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${disvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${IRTvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${predictedvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${predictedvar}_fxd "`countrylab'" "'
	local rename_dM `"`rename_dM' `country'.${countryvar} "`countrylab'" "'
/**/							}
numlabel `countrylabel', mask(#_) add
* The ESTTAB command
global esttabopts `"nostar b(%3.1f) ci(%3.1f) transform(@*100 100) varwidth(20) modelwidth(8 15 8 15 8 15 8 15)"'
global esttabopts `"${esttabopts} coeflabels(`labels') nonum replace nolegend nobaselevels wide"'
global esttabopts `"${esttabopts} mtitles(LLSI Factor "Predicted (fixed)" "Predicted (random)")  mgroups("Observed" "Alternative measures", pattern(1 1 0 0))"'			 
global esttabopts `"${esttabopts} addnotes("Table created on `c(current_date)'" "INSTRUCTIONS FOR FORMATTING: headings into bold, change font & size, reduce size for CI cols, merge titles, remove internal margins, then double-click to reduce width of cols, under table style")"'
global order1	  `"order("Liberal" USA England "Social Democratic A" Denmark Netherlands Switzerland "Social Democratic B" Germany Sweden "Corporatist-A" Austria Belgium "Corporatist-C" Czechia Slovenia Spain "Southern" Italy France Greece "Other" Estonia Israel)"' // REMOVED "Corporatist-B" Poland 
esttab eMr* using "${dodir}\Outputs\1.nonbootstrap_empR.rtf", ${esttabopts} ${order1} rename(`rename_eMr' ) title("Disability employment gap")
esttab eMi* using "${dodir}\Outputs\1.nonbootstrap_empM.rtf", ${esttabopts} ${order1} rename(`rename_eMi' ) title("Disability employment rate") drop (*0.${disvar}*)
esttab dM* using "${dodir}\Outputs\1.nonbootstrap_disR.rtf" , ${esttabopts} ${order1} rename(`rename_dM' ) title("Disability rate")
* Outputting to Tab-delimited for importing into Excel
esttab eMr* using "${dodir}\Outputs\1.nonbootstrap_empR.csv", plain ${esttabopts} ${order1} rename(`rename_eMr' ) title("Disability employment gap")
esttab eMi* using "${dodir}\Outputs\1.nonbootstrap_empM.csv", plain ${esttabopts} ${order1} rename(`rename_eMi' ) title("Disability employment rate") drop (*0.${disvar}*)
esttab dM* using "${dodir}\Outputs\1.nonbootstrap_disR.csv" , plain ${esttabopts} ${order1} rename(`rename_dM' ) title("Disability rate")
